/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE SYNCHRONOUS 4-BIT BINARY COUNTER
TRUTHTABLE     : 
+---------------------------------------+-----------------------+
|              INPUT                    |                       |
+---------------------------------------+       OPERATION       |
|      CLR_    LOAD_   ENT  ENP    CLK  |                       |
+---------------------------------------+-----------------------+
|                                   _   |                       |
|      L        X     X     X     _/    |   Synchronous Clear   | 
|                                   _   |                       |
|      H        L     X     X     _/    |   Load Parrallel Data |
|                                   _   |                       |
|      H        H     H     H     _/    |   Binary Counter      |
|                                       |                       |
|      H        H     L     X      X    |   Inhibit Counting    |
|                                       |                       |
|      H        H     X     L      X    |   Inhibit Counting    |
+---------------------------------------+-----------------------+

Note : RCO goes high at the terminal count for the duration
       of one clock pulse.


REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a163 (clrn, clk, a, b, c, d, enp, ldn, ent, qd, qc, qb, qa, rco);
	parameter size =1;
	input
		clrn,
		clk,
		a,
		b,
		c,
		d,
		enp,
		ldn,
		ent;
	output
		qd,
		qc,
		qb,
		qa,
		rco;
    reg
        NOTIFY_REG;
    not
	N1 (load, ldn);
    and
	A1 (en1, load, clrn);
    and
	A2 (en2, ldn, clrn);
    and
	A3 (en3, en2, ent);
    and
	A4 (en4, en2, enp);
    not
	M163_inst_I1 (m163_inst_wi1, ldn);
    not
	M163_inst_I2 (m163_inst_wi2, clrn);
    nor
	M163_inst_NO1 (m163_inst_wno1, m163_inst_wna1, m163_inst_wi2);
    nor
	M163_inst_NO2 (m163_inst_wno2, ldn, m163_inst_wi2);
    nor
	M163_inst_NO3 (m163_inst_wno3, m163_inst_wi1, m163_inst_wi2);
    xor
	M163_inst_XOR1 (m163_inst_wxo1, m163_inst_wa1, m163_inst_wno1);
    nand
	M163_inst_NA1 (m163_inst_wna1, ent, enp, ldn);
    and
	M163_inst_A1 (m163_inst_wa1, m163_inst_wno3, m163_inst_qaint);
    and  
	M163_inst_A12 (rco, dd_net_34, m163_inst_qaint, m163_inst_qbint, m163_inst_qcint, m163_inst_qdint);
    buf  
	  (qa, m163_inst_qaint);
    buf  
	  (qb, m163_inst_qbint);
    buf  
	  (qc, m163_inst_qcint);
    buf  
	  (qd, m163_inst_qdint);
    U_AO_3
	M163_inst_inst1_inst1 (m163_inst_wo1, m163_inst_wxo1, m163_inst_wno2, a);
    U_AXO_2_2
	M163_inst_inst2_inst1 (m163_inst_wxo2, m163_inst_wno3, m163_inst_qbint, m163_inst_wno1, m163_inst_qaint);
    U_AO_3
	M163_inst_inst3_inst1 (m163_inst_wo2, m163_inst_wxo2, m163_inst_wno2, b);
    U_AXO_2_3
	M163_inst_inst4_inst1 (m163_inst_wxo3, m163_inst_wno3, m163_inst_qcint, m163_inst_wno1, m163_inst_qaint, m163_inst_qbint);
    U_AO_3
	M163_inst_inst5_inst1 (m163_inst_wo3, m163_inst_wxo3, m163_inst_wno2, c);
    U_AXO_2_4
	M163_inst_inst6_inst1 (m163_inst_wxo4, m163_inst_wno3, m163_inst_qdint, m163_inst_wno1, m163_inst_qaint, m163_inst_qbint, m163_inst_qcint);
    U_AO_3
	M163_inst_inst7_inst1 (m163_inst_wo4, m163_inst_wxo4, m163_inst_wno2, d);
    U_FD_P_NO  
	M163_inst_DFF1_inst1 (m163_inst_qaint, m163_inst_wo1, clk, NOTIFY_REG);
    U_FD_P_NO  
	M163_inst_DFF2_inst1 (m163_inst_qbint, m163_inst_wo2, clk, NOTIFY_REG);
    U_FD_P_NO  
	M163_inst_DFF3_inst1 (m163_inst_qcint, m163_inst_wo3, clk, NOTIFY_REG);
    U_FD_P_NO  
	M163_inst_DFF4_inst1 (m163_inst_qdint, m163_inst_wo4, clk, NOTIFY_REG);
    buf  
	  (dd_net_34, ent);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
